/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__assertions.c,v 1.37 2006/08/29 21:44:09 loic Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mcp_requests.h"
#include "mcp_events.h"
#include "mcp_global.h"
#include "mx__driver_interface.h"
#include "mx_raw.h"
#include "mx__wire.h"
#include "mx__requests.h"

#define CTA(x) do { char (*a)[(x) ? 1 : -1] = 0; (void) a; } while (0)

void
mx__assertions(void)
{
  CTA(sizeof (uintptr_t) == sizeof (void*));
  
  /* This must be a multiple of 8 because of the optimized 
     64-bit copy we use on 64-bit platforms */
  CTA((sizeof (mcp_ureq_t) % 8) == 0);
  
  /* If this is changed, then mx_copy_usend_sse()
     must be updated */
  CTA(sizeof (mcp_ureq_t) == 64);

  /* mcp_kreq_ether_send_t and mcp_kreq_ether_recv_t had better be
     powers of 2. Some ethernet code use them as part of the
     calculation for a mask. */
  CTA(sizeof (mcp_kreq_ether_send_t) == 16);
  CTA(sizeof (mcp_kreq_ether_recv_t) == 8);

  /* make sure the hostname is 8-byte aligned in the globals */
  CTA(offsetof(mx_mcp_public_global_t, hostname) % 8  == 0);
  CTA(offsetof(mx_mcp_public_global_t, ether_tx_ring) % 8  == 0);
  
  CTA(sizeof (mcp_uevt_t) == 64);

  /* We try to pad ioctl structs so that they don't suffer from
     32 bit/64 bit issues. Bark if they aren't the size we think
     they're supposed to be. NOTE: Only structs with 64 bit values
     are padded to a 8 byte boundary. Otherwise, they're padded to
     a 4 byte boundary. */
  CTA(sizeof (mx_opener_t) == 72);
  CTA(sizeof (mx_get_opener_t) == 84);
  CTA(sizeof (mx_crashdump_t) == 24);
  CTA(sizeof (mx_get_nic_id_t) == 16);
  CTA(sizeof (mx_set_endpt_t) == 8);
  CTA(sizeof (mx_get_copyblock_t) == 64);
  CTA(sizeof (mx_reg_seg_t) == 16);
  CTA(sizeof (mx_reg_t) == (MX_DRIVER_API_MAGIC >= 0x500 ? 40 : 32));
  CTA(sizeof (mx_get_counters_strings_t) == 136);
  CTA(sizeof (mx_get_logging_strings_t) == 136);
  CTA(sizeof (mx_nic_id_to_board_num_t) == 16);
  CTA(sizeof (mx_get_logging_t) == 16);
  CTA(sizeof (mx_lookup_peer_t) == 16);
  CTA(sizeof (mx_get_peer_format_t) == 12);
  CTA(sizeof (mx_get_route_table_t) == 16);
  CTA(sizeof (mx_mmap_t) == 24);
  CTA(sizeof (mx_nic_id_hostname_t) == 24);
  CTA(sizeof (mx_set_hostname_t) == 16);
  CTA(sizeof (mx_set_route_t) == 24);
  CTA(sizeof (mx_direct_get_t) == 32);
  CTA(sizeof (mx_shm_seg_t) == 16);
  CTA(sizeof (mx_direct_getv_t) == 56);
  CTA(sizeof (mx_irq_counters_t) == 16);
  CTA(sizeof (mx_dmabench_t) == 16);
  CTA(sizeof (mx_raw_send_t) == 32);
  CTA(sizeof (mx_raw_next_event_t) == 32);
  CTA(sizeof (mx_mapper_state_t) == 36);
  CTA(sizeof (mx_wait_t) == 16);
  CTA(sizeof (mx_get_version_t) == 192);
  CTA(MX_KRAW_NO_EVENT == MX_RAW_NO_EVENT);
  CTA(MX_KRAW_SEND_COMPLETE == MX_RAW_SEND_COMPLETE);
  CTA(MX_KRAW_RECV_COMPLETE == MX_RAW_RECV_COMPLETE);

  CTA(sizeof (union mx__lib2lib) <= MX_MCP_RECV_TRUC_MAX_SIZE);
  CTA(MX__MAX_SMALL_LEN >= sizeof(mcp_ureq_t) + MCP_UREQ_ALIGNMENT);
}
